#!/bin/bash
#
# Install Net Protector
#
# Copyright @2024 Biz Secure Labs Pvt. Ltd.
#
# ========================================================
# ========================================================
# Mod Date : 2025-04-01 14:13:53
# Author   : Akshay Jadhav
# Change   : Check ROOT access available
# ========================================================
# ========================================================

BASEDIR=$(dirname "$0")
SETUP_TARFILE="NetProtector.tar.gz"
INSTALL_TEMP_DIR="nplintemp"
INSTALL_LOG_FILE="npinstall.log"
INSTALL_DIR_NAME="NetProtector-EPS"
INSTALL_DIR="/usr/lib"
LICENSEINFO_FILE=$BASEDIR+"/licenseinfo"

# Start main()
echo -e '\E[1;32m'"Installation Started"; tput sgr0
echo "Installation Started" >>$INSTALL_LOG_FILE
date >>$INSTALL_LOG_FILE


# Check user is root or not
if [ $(id -u) -ne 0 ]
then
	echo -e '\E[0;31m'"Please login as root user or run as sudo and try again."; tput sgr0
	exit 1
fi


# Check tar file available or not
if [ ! -e "$SETUP_TARFILE" ]
then
	echo -e '\E[0;31m'"$SETUP_TARFILE file not found."; tput sgr0
	exit 1
fi


# Handle terminate signal
function do_for_sigint() {
	echo -e '\E[0;31m'"Installation Terminated."; tput sgr0
	exit 1
}
trap 'do_for_sigint' 2


# Create or clear temp directory
if [ ! -d "$INSTALL_TEMP_DIR" ]
then
	mkdir -p $INSTALL_TEMP_DIR
	chmod 0755 $INSTALL_TEMP_DIR
fi
rm -rf $INSTALL_TEMP_DIR/*


# Extract package to temp directory
echo -e '\E[0;34m'" => Extracting files";  tput sgr0
tar -xzvf $SETUP_TARFILE --directory=$INSTALL_TEMP_DIR > /dev/null 2>>$INSTALL_LOG_FILE
if [ $? -ne 0 ]
then
	echo -e '\E[0;31m'"Something went wrong! Failed to extract some files."; tput sgr0
	rm -rdf $INSTALL_TEMP_DIR
	exit 1
fi


# Change Permissions
echo -e '\E[0;34m'" => Changing Permissions";  tput sgr0
chmod 0755 $INSTALL_TEMP_DIR/* 2>>$INSTALL_LOG_FILE


# Copy Files
echo -e '\E[0;34m'" => Copying Files";  tput sgr0
mkdir -p  $INSTALL_DIR/$INSTALL_DIR_NAME
cp -R ./$INSTALL_TEMP_DIR/$INSTALL_DIR_NAME/* $INSTALL_DIR/$INSTALL_DIR_NAME 2>>$INSTALL_LOG_FILE


# Remove temp directory
echo -e '\E[0;34m'" => Removing Temporary Files.";  tput sgr0
rm -rdf ./$INSTALL_TEMP_DIR/


# Start Setup
echo -e '\E[0;34m'" => Setuping Database and Permissions";  tput sgr0
sh $INSTALL_DIR/$INSTALL_DIR_NAME/setupdb.sh > /dev/null >>$INSTALL_LOG_FILE


# Start Activation Process
echo -e '\E[0;34m'" => Starting Activation Process";  tput sgr0

CURRENT_USER=$(echo $(logname))
if [[ ($CURRENT_USER =~ "logname: no login name") || ($CURRENT_USER = "") ]]
then
	CURRENT_USER=$(echo $USER)
fi
echo "Current User: " $CURRENT_USER


#if [ "$CURRENT_USER" != "root" ]
#then
#	cp /home/$CURRENT_USER/.Xauthority /root
#fi
#runuser -u $CURRENT_USER sh $INSTALL_DIR/$INSTALL_DIR_NAME/npavtopup.sh /force > /dev/null>>$INSTALL_LOG_FILE

# Start Tray Application
runuser -u $CURRENT_USER sh $INSTALL_DIR/$INSTALL_DIR_NAME/start_nptray.sh

if [ -f $LICENSEINFO_FILE ]
then
	sh $INSTALL_DIR/$INSTALL_DIR_NAME/npavtopupc.sh $LICENSEINFO_FILE
else
	sh $INSTALL_DIR/$INSTALL_DIR_NAME/npavtopupc.sh
fi
	
# Installation Completed
if [ $? -ne 0 ]
then
	echo "Installation Completed! But Activation Failed." >>$INSTALL_LOG_FILE
	echo -e '\E[0;31m'"Installation Completed! But Activation Failed.";  tput sgr0
else
# Start Tray Process
	echo "Installation Completed." >>$INSTALL_LOG_FILE
	echo -e '\E[0;32m'"Installation Completed.";  tpu2t sgr0
fi



